/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.TimeValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;
import java.util.List;

public abstract class Time2ProtectionParameter
extends ProtectionParameter {
    static final long serialVersionUID = 0L;
    private int serializedDataVersion = 1;
    protected Timer fHTimer;
    protected Timer fLTimer;
    protected transient Timer fTimer;
    protected transient int fState;
    protected static final int READY = 0;
    protected static final int H_TIME_ACTIVE = 1;
    protected static final int L_TIME_ACTIVE = 2;
    protected static final int RUNNING = 3;

    public Time2ProtectionParameter() {
    }

    public Time2ProtectionParameter(Block block) {
        super(block);
        this.fData = 1;
        this.fParameter = 2;
        this.fAllocatedTimer = 1;
        this.fState = 0;
    }

    public String calculateCurrentParameterText() {
        return this.getCurrentTimer().getPassedTime().getTimeAsString();
    }

    protected Timer getCurrentTimer() {
        if (this.fTimer == null) {
            this.fTimer = this.getLTimer();
        }
        return this.fTimer;
    }

    public TimeUnit getCurrentTimerPassedTime() {
        return this.getCurrentTimer().getPassedTime();
    }

    public void setCurrentTimerPassedTime(TimeUnit newValue) {
        throw new IllegalStateException("The method " + this.getClass().getName() + ".setCurrentTimerPassedTime(TimeUnit) is not supported");
    }

    public Timer getHTimer() {
        if (this.fHTimer == null) {
            this.fHTimer = new Timer("TH");
        }
        return this.fHTimer;
    }

    public TimeUnit getHTimerPassedTime() {
        return this.getHTimer().getPassedTime();
    }

    public TimeValueProperties getHTimerParamTime() {
        return this.getHTimer().getParamTimeProperties();
    }

    public TimeUnit getRestTimeH() {
        if (this.fState == 1) {
            return this.getHTimer().getRemainingTimeForShowing();
        }
        return TimeUnit.getNewTimeObject(this.getHTimer().getParamTime().getUnitKey());
    }

    public TimeUnit getRestTimeL() {
        if (this.fState == 2) {
            return this.getLTimer().getRemainingTimeForShowing();
        }
        return TimeUnit.getNewTimeObject(this.getLTimer().getParamTime().getUnitKey());
    }

    public void setLTimerParamTime(TimeValueProperties newTime) {
        newTime.setParameter(this);
        this.getLTimer().setParamTimeProperties(newTime);
    }

    public void setHTimerParamTime(TimeValueProperties newTime) {
        newTime.setParameter(this);
        this.getHTimer().setParamTimeProperties(newTime);
    }

    public TimeUnit getLTimerPassedTime() {
        return this.getLTimer().getPassedTime();
    }

    public TimeValueProperties getLTimerParamTime() {
        return this.getLTimer().getParamTimeProperties();
    }

    public Timer getLTimer() {
        if (this.fLTimer == null) {
            this.fLTimer = new Timer("TL");
        }
        return this.fLTimer;
    }

    public String getParameterText() {
        StringBuffer result = new StringBuffer(super.getParameterText());
        if (result.length() > 0) {
            result.append("\n");
        }
        result.append(this.getHTimer().getParamTime().getParameterText());
        result.append(this.getProtectionSign());
        result.append("\n");
        result.append(this.getLTimer().getParamTime().getParameterText());
        return result.toString();
    }

    public boolean getValue(boolean trg) {
        boolean result = this.calculateValue(trg);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return result;
    }

    public boolean getValue(boolean param1, boolean param2) {
        boolean result = this.calculateValue(param1, param2);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return result;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.getHTimer().init(interpreter);
        this.getLTimer().init(interpreter);
        if (forceReset || !this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence()) {
            this.fTimer = this.getLTimer();
            this.getHTimer().reset();
            this.getLTimer().reset();
            this.fState = 0;
        }
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fHTimer = (Timer)dr.readStorable();
        this.fLTimer = (Timer)dr.readStorable();
    }

    protected void setCurrentTimer(Timer newTimer) {
        this.fTimer = newTimer;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fHTimer);
        dw.writeStorable(this.fLTimer);
    }

    public boolean isAvailable(Hardware hardware, List errorList) {
        boolean available = super.isAvailable(hardware, errorList);
        TimeUnit[] availableTimeUnits = (TimeUnit[])hardware.getProperty("availableTimeUnits");
        boolean hTimerCompatible = this.getHTimer().isTimerConvertibleTo(availableTimeUnits);
        boolean lTimerCompatible = this.getLTimer().isTimerConvertibleTo(availableTimeUnits);
        if (!this.getHTimer().getParamTimeProperties().isReference() && !hTimerCompatible) {
            errorList.add(new ErrorInfo(this, "error.convert.timerNotConvertible", hardware));
            return false;
        }
        if (!this.getLTimer().getParamTimeProperties().isReference() && !lTimerCompatible) {
            errorList.add(new ErrorInfo(this, "error.convert.timerNotConvertible", hardware));
            return false;
        }
        if ((this.getHTimer().getParamTimeProperties().isReference() || this.getLTimer().getParamTimeProperties().isReference()) && !hardware.supports("Time2Protection_ref")) {
            errorList.add(new ErrorInfo(this, Language.getString("error.hardware.referenceNotSupported", "The reference is not supported by the device %.", hardware.getLocalizedPath() + hardware.getLocalizedName()), hardware));
            return false;
        }
        if (this.getRemanenceAvailable() && !hardware.supports("REMTimer") && this.getRemanenceObject().getRemanence()) {
            errorList.add(new ErrorInfo(this, "error.convert.timerWithREM", hardware));
            return false;
        }
        return available;
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChanged(hardwareChangedEvent);
        Hardware hardware = (Hardware)hardwareChangedEvent.getNewValue();
        TimeUnit[] availableTimeUnits = (TimeUnit[])hardware.getProperty("availableTimeUnits");
        this.getHTimer().convertTimerTo(availableTimeUnits);
        this.getLTimer().convertTimerTo(availableTimeUnits);
    }

    public int getTHTimeBase() {
        return Util.getTimeBase(this.getHTimer().getParamTime());
    }

    public int getTLTimeBase() {
        return Util.getTimeBase(this.getLTimer().getParamTime());
    }

    public int getTaTimeBase() {
        return Util.getTimeBase(this.getCurrentTimerPassedTime());
    }
}

